/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.aaconfig;

import com.ibm.hwmca.base.aaconfig.AutoAnswerConfigBean;
import com.ibm.hwmca.base.aaconfig.AutoAnswerConfigData;
import com.ibm.hwmca.base.aaconfig.AutoAnswerConfigErrorIds;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public class AutoAnswerConfigTasklet
extends PanelTasklet
implements AutoAnswerConfigErrorIds {
    private static final String TRACE_MASKT = "HAACTLTT";
    private static final String TRACE_MASKF = "HAACTLTF";
    private static final String TRACE_MASKD = "HAACTLTD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-89, "AAConfigTklt");
    private static final String AUIML = "com.ibm.hwmca.base.aaconfig.res.AutoAnswerConfigRes";
    private static final String PANEL = "AutoAnswerConfigPanel";
    private static final String PARENT_BEAN = "BASETOWERSETTINGSBEAN";

    public AutoAnswerConfigTasklet() {
        Trace.trace(TRACE_MASKT, "<-> AutoAnswerConfigTasklet()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                AutoAnswerConfigBean bean = new AutoAnswerConfigBean();
                bean.setBeanName("bean");
                AutoAnswerConfigData data = AutoAnswerConfigData.getAutoAnswerConfigData();
                bean.setLoginEdit(data.getLogin());
                bean.setPasswordEdit("");
                bean.setConfirmEdit("");
                response.replace(AUIML, PANEL, bean);
            } else if (request.isDisposed() || request.isCanceled()) {
                PanelTaskletRequest newRequest = new PanelTaskletRequest();
                newRequest.setDisposed();
                if (this.isSubtasklet()) {
                    this.getParent().postRequest(PARENT_BEAN, newRequest);
                }
                response.terminate();
            } else {
                String action = (String)request.getData("action");
                Trace.trace(TRACE_MASKF, "action=" + action);
                if (action.equals("commit")) {
                    AutoAnswerConfigBean bean = (AutoAnswerConfigBean)request.getData("bean");
                    AutoAnswerConfigData data = AutoAnswerConfigData.getAutoAnswerConfigData();
                    data.setLogin(bean.getLoginEdit());
                    if (!bean.getPasswordEdit().equals("")) {
                        data.setPassword(bean.getPasswordEdit());
                    }
                    PanelTaskletRequest newRequest = new PanelTaskletRequest();
                    newRequest.setDisposed();
                    if (this.isSubtasklet()) {
                        this.getParent().postRequest(PARENT_BEAN, newRequest);
                    }
                    response.terminate();
                } else {
                    response.noAction();
                }
            }
        }
        catch (Exception e) {
            TaskletException texc = new TaskletException(e);
            new FrameworkLog(logInfo, 3, texc).log();
            throw texc;
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(logInfo, 1, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }
}

